/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.api.dto.EventDataType;
import biz.everit.audit.hook.client.AuditClient;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.BaseModelListener;
import java.util.ArrayList;

public class AddressModificationAudit
extends BaseModelListener<Address> {
    private final AuditClient auditClient = new AuditClient();
    private static final String CREATE_ADDRESS = "createAddress";
    private static final String UPDATE_ADDRESS = "updateAddress";
    private static final String REMOVE_ADDRESS = "removeAddress";

    private Event getEventFromAddress(String eventName, Address address) {
        ArrayList<EventData> eventDataArray = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setName("addressId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(address.getAddressId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("userId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(address.getUserId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("street1");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(address.getStreet1());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("street2");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(address.getStreet2());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("street3");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(address.getStreet3());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("city");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(address.getCity());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("zip");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(address.getZip());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("countryId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(address.getCountryId()));
        eventDataArray.add(ed);
        Event event = new Event(null, eventName, "liferayAuditHook", null, eventDataArray.toArray(new EventData[0]));
        return event;
    }

    public void onAfterCreate(Address address) throws ModelListenerException {
        Event event = this.getEventFromAddress(CREATE_ADDRESS, address);
        this.auditClient.logEvent(event);
    }

    public void onAfterRemove(Address address) throws ModelListenerException {
        Event event = this.getEventFromAddress(REMOVE_ADDRESS, address);
        this.auditClient.logEvent(event);
    }

    public void onAfterUpdate(Address address) throws ModelListenerException {
        Event event = this.getEventFromAddress(UPDATE_ADDRESS, address);
        this.auditClient.logEvent(event);
    }
}

