/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.api.dto.EventDataType;
import biz.everit.audit.hook.client.AuditClient;
import biz.everit.audit.hook.util.DateUtil;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Contact;
import java.util.ArrayList;
import java.util.Date;

public class ContactModificationAudit
extends BaseModelListener<Contact> {
    private final AuditClient auditClient = new AuditClient();
    private static final String CREATE_CONTACT = "createContact";
    private static final String UPDATE_CONTACT = "updateContact";
    private static final String REMOVE_CONTACT = "removeContact";

    private Event getEventFromContact(String eventName, Contact contact) {
        ArrayList<EventData> eventDataArray = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setName("contactId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(contact.getContactId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("userId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(contact.getUserId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("male");
        ed.setEventDataType(EventDataType.NUMBER);
        if (contact.isMale()) {
            ed.setNumberValue(new Double(1.0));
        } else {
            ed.setNumberValue(new Double(0.0));
        }
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("bitrhday");
        ed.setEventDataType(EventDataType.TIMESTAMP);
        ed.setTimestampValue(DateUtil.dateToCal((Date)contact.getBirthday()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("jobtitle");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(contact.getJobTitle());
        eventDataArray.add(ed);
        Event event = new Event(null, eventName, "liferayAuditHook", null, eventDataArray.toArray(new EventData[0]));
        return event;
    }

    public void onAfterCreate(Contact contact) throws ModelListenerException {
        Event event = this.getEventFromContact(CREATE_CONTACT, contact);
        this.auditClient.logEvent(event);
    }

    public void onAfterRemove(Contact contact) throws ModelListenerException {
        Event event = this.getEventFromContact(REMOVE_CONTACT, contact);
        this.auditClient.logEvent(event);
    }

    public void onAfterUpdate(Contact contact) throws ModelListenerException {
        Event event = this.getEventFromContact(UPDATE_CONTACT, contact);
        this.auditClient.logEvent(event);
    }
}

