/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.api.dto.EventDataType;
import biz.everit.audit.hook.client.AuditClient;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portlet.expando.model.ExpandoValue;
import java.util.ArrayList;

public class ExpandoValueModificationAudit
extends BaseModelListener<ExpandoValue> {
    private final AuditClient auditClient = new AuditClient();
    private static final String CREATE_EXPANDO = "createExpando";
    private static final String UPDATE_EXPANDO = "updateExpando";
    private static final String REMOVE_EXPANDO = "removeExpando";

    private Event getEventFromExpando(String eventName, ExpandoValue expando) {
        ArrayList<EventData> eventDataArray = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setName("valueId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(expando.getValueId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("tableId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(expando.getTableId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("columnId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(expando.getColumnId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("rowId_");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(expando.getRowId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("classNameId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(expando.getClassNameId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("data_");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(expando.getData());
        eventDataArray.add(ed);
        Event event = new Event(null, eventName, "liferayAuditHook", null, eventDataArray.toArray(new EventData[0]));
        return event;
    }

    public void onAfterCreate(ExpandoValue expando) throws ModelListenerException {
        Event event = this.getEventFromExpando(CREATE_EXPANDO, expando);
        this.auditClient.logEvent(event);
    }

    public void onAfterRemove(ExpandoValue expando) throws ModelListenerException {
        Event event = this.getEventFromExpando(REMOVE_EXPANDO, expando);
        this.auditClient.logEvent(event);
    }

    public void onAfterUpdate(ExpandoValue expando) throws ModelListenerException {
        Event event = this.getEventFromExpando(UPDATE_EXPANDO, expando);
        this.auditClient.logEvent(event);
    }
}

