/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.api.dto.EventDataType;
import biz.everit.audit.hook.client.AuditClient;
import biz.everit.audit.hook.util.DateUtil;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import java.util.ArrayList;
import java.util.Date;

public class FileEntryModificationAudit
extends BaseModelListener<DLFileEntry> {
    private final AuditClient auditClient = new AuditClient();
    private static final String CREATE_FILE = "createDLFileEntry";
    private static final String UPDATE_FILE = "updateDLFileEntry";
    private static final String REMOVE_FILE = "removeDLFileEntry";

    private Event getEventFromDLFileEntry(String eventName, DLFileEntry file) {
        ArrayList<EventData> eventDataArray = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setName("createDate");
        ed.setEventDataType(EventDataType.TIMESTAMP);
        ed.setTimestampValue(DateUtil.dateToCal((Date)file.getCreateDate()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("description");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(file.getDescription());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("extension");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(file.getExtension());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("fileEntryId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(file.getFileEntryId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("folderId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(file.getFolderId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("modifiedDate");
        ed.setEventDataType(EventDataType.TIMESTAMP);
        ed.setTimestampValue(DateUtil.dateToCal((Date)file.getModifiedDate()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("name");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(file.getName());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("size_");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(file.getSize()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("userId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(file.getUserId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("uuid_");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(file.getUuid());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("version");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(file.getVersion());
        eventDataArray.add(ed);
        eventDataArray.add(ed);
        Event event = new Event(null, eventName, "liferayAuditHook", null, eventDataArray.toArray(new EventData[0]));
        return event;
    }

    public void onAfterCreate(DLFileEntry file) throws ModelListenerException {
        Event event = this.getEventFromDLFileEntry(CREATE_FILE, file);
        this.auditClient.logEvent(event);
    }

    public void onAfterRemove(DLFileEntry file) throws ModelListenerException {
        Event event = this.getEventFromDLFileEntry(REMOVE_FILE, file);
        this.auditClient.logEvent(event);
    }

    public void onAfterUpdate(DLFileEntry file) throws ModelListenerException {
        Event event = this.getEventFromDLFileEntry(UPDATE_FILE, file);
        this.auditClient.logEvent(event);
    }
}

