/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.api.dto.EventDataType;
import biz.everit.audit.hook.client.AuditClient;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Organization;
import java.util.ArrayList;

public class OrganizationModificationAudit
extends BaseModelListener<Organization> {
    private final AuditClient auditClient = new AuditClient();
    private static final String CREATE_ORGANIZATION = "createOrganization";
    private static final String UPDATE_ORGANIZATION = "updateOrganization";
    private static final String REMOVE_ORGANIZATION = "removeOrganization";

    private Event getEventFromOrganization(String eventName, Organization organization) {
        ArrayList<EventData> eventDataArray = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setName("companyId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(organization.getCompanyId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("countryId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(organization.getCountryId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("name");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(organization.getName());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("organizationId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(organization.getOrganizationId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("parentOrganizationId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(organization.getParentOrganizationId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("regionId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(organization.getRegionId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("statusId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(organization.getStatusId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("type_");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(organization.getType());
        eventDataArray.add(ed);
        eventDataArray.add(ed);
        Event event = new Event(null, eventName, "liferayAuditHook", null, eventDataArray.toArray(new EventData[0]));
        return event;
    }

    public void onAfterCreate(Organization organization) throws ModelListenerException {
        Event event = this.getEventFromOrganization(CREATE_ORGANIZATION, organization);
        this.auditClient.logEvent(event);
    }

    public void onAfterRemove(Organization organization) throws ModelListenerException {
        Event event = this.getEventFromOrganization(REMOVE_ORGANIZATION, organization);
        this.auditClient.logEvent(event);
    }

    public void onAfterUpdate(Organization organization) throws ModelListenerException {
        Event event = this.getEventFromOrganization(UPDATE_ORGANIZATION, organization);
        this.auditClient.logEvent(event);
    }
}

