/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.api.dto.EventDataType;
import biz.everit.audit.hook.client.AuditClient;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Phone;
import java.util.ArrayList;

public class PhoneModificationAudit
extends BaseModelListener<Phone> {
    private final AuditClient auditClient = new AuditClient();
    private static final String CREATE_PHONE = "createPhone";
    private static final String UPDATE_PHONE = "updatePhone";
    private static final String REMOVE_PHONE = "removePhone";

    private Event getEventFromPhone(String eventName, Phone phone) {
        ArrayList<EventData> eventDataArray = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setName("phoneId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(phone.getPhoneId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("userId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(phone.getUserId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("number_");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(phone.getNumber());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("typeId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(phone.getTypeId()));
        eventDataArray.add(ed);
        Event event = new Event(null, eventName, "liferayAuditHook", null, eventDataArray.toArray(new EventData[0]));
        return event;
    }

    public void onAfterCreate(Phone phone) throws ModelListenerException {
        Event event = this.getEventFromPhone(CREATE_PHONE, phone);
        this.auditClient.logEvent(event);
    }

    public void onAfterRemove(Phone phone) throws ModelListenerException {
        Event event = this.getEventFromPhone(REMOVE_PHONE, phone);
        this.auditClient.logEvent(event);
    }

    public void onAfterUpdate(Phone phone) throws ModelListenerException {
        Event event = this.getEventFromPhone(UPDATE_PHONE, phone);
        this.auditClient.logEvent(event);
    }
}

