/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.api.dto.EventDataType;
import biz.everit.audit.hook.client.AuditClient;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.User;
import java.util.ArrayList;

public class UserModificationAudit
extends BaseModelListener<User> {
    private final AuditClient auditClient = new AuditClient();
    private static final String CREATE_USER = "createUser";
    private static final String UPDATE_USER = "updateUser";
    private static final String REMOVE_USER = "removeUser";

    private Event getEventFromUser(String eventName, User user) {
        ArrayList<EventData> eventDataArray = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setName("userId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(user.getUserId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("screenName");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(user.getScreenName());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("emailAddress");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(user.getEmailAddress());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("firstName");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(user.getFirstName());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("middleName");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(user.getMiddleName());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("lastName");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(user.getLastName());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("jobTitle");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(user.getJobTitle());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("portraitId");
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(new Double(user.getPortraitId()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("active_");
        ed.setEventDataType(EventDataType.NUMBER);
        if (user.isActive()) {
            ed.setNumberValue(new Double(1.0));
        } else {
            ed.setNumberValue(new Double(0.0));
        }
        eventDataArray.add(ed);
        Event event = new Event(null, eventName, "liferayAuditHook", null, eventDataArray.toArray(new EventData[0]));
        return event;
    }

    public void onAfterCreate(User user) throws ModelListenerException {
        Event event = this.getEventFromUser(CREATE_USER, user);
        this.auditClient.logEvent(event);
    }

    public void onAfterRemove(User user) throws ModelListenerException {
        Event event = this.getEventFromUser(REMOVE_USER, user);
        this.auditClient.logEvent(event);
    }

    public void onAfterUpdate(User user) throws ModelListenerException {
        Event event = this.getEventFromUser(UPDATE_USER, user);
        this.auditClient.logEvent(event);
    }
}

