/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook.client;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.hook.util.EventFactory;
import biz.everit.audit.jms.client.service.AuditJmsService;
import biz.everit.audit.jms.client.service.impl.AuditJmsServiceImpl;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AuditClient.class);
    private static final String JMS_CONNECTION_FACTORY_NAME = "jms/auditJmsConnectionFactory";
    private static final String JMS_QUEUE_NAME = "jms/auditJmsQueue";
    private AuditJmsService jmsService;

    public AuditClient() {
        try {
            this.jmsService = new AuditJmsServiceImpl(JMS_CONNECTION_FACTORY_NAME, JMS_QUEUE_NAME);
        }
        catch (NamingException e) {
            LOGGER.error("Naming exception: ", (Throwable)e);
        }
    }

    private String eventDatasToString(EventData[] eventDataArray) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        int i = 0;
        for (EventData eventData : eventDataArray) {
            sb.append(" [" + i + ": " + eventData.getName());
            if (eventData.getBinaryValue() != null) {
                sb.append(", binary value: " + eventData.getBinaryValue().length + " bytes long");
            }
            if (eventData.getNumberValue() != null) {
                sb.append(", number value: " + eventData.getNumberValue());
            }
            if (eventData.getTextValue() != null) {
                sb.append(", text value: " + eventData.getTextValue());
            }
            if (eventData.getTimestampValue() != null) {
                sb.append(", timestamp value: " + eventData.getTimestampValue());
            }
            sb.append(" ]");
            ++i;
        }
        sb.append(" ]");
        return sb.toString();
    }

    public void logEvent(Event event) {
        Event filledEvent = EventFactory.fillEvent((Event)event);
        if (this.jmsService != null) {
            this.jmsService.log(filledEvent);
        } else {
            LOGGER.error("Cannot audit, because audit client is null!");
            LOGGER.debug("Appname: " + event.getApplicationName() + " EventType: " + event.getName() + " Data: " + this.eventDatasToString(event.getEventDataArray()));
        }
    }
}

