/*
 * Decompiled with CFR 0.152.
 */
package biz.everit.audit.hook.util;

import biz.everit.audit.api.dto.Event;
import biz.everit.audit.api.dto.EventData;
import biz.everit.audit.api.dto.EventDataType;
import biz.everit.audit.util.context.ServletRequestContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.transaction.TransactionSynchronizationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EventFactory {
    private static final String ACTOR = User.class.getName();
    private static final String SESSION_TYPE = "session";
    private static final String TRANSACTION_TYPE = "transaction";
    private static final String ACTOR_EMAIL = "userEmail";
    protected static final Logger LOGGER = LoggerFactory.getLogger(EventFactory.class);

    private static List<EventData> createPrefilledEventDatas() {
        ArrayList<EventData> eventDataArray = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setName("session");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(EventFactory.getSessionId());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("transaction");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(EventFactory.getTransactionId());
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName(ACTOR);
        ed.setEventDataType(EventDataType.NUMBER);
        ed.setNumberValue(Double.valueOf(EventFactory.getUserId().doubleValue()));
        eventDataArray.add(ed);
        ed = new EventData();
        ed.setName("userEmail");
        ed.setEventDataType(EventDataType.STRING);
        ed.setTextValue(EventFactory.getUserEmail());
        eventDataArray.add(ed);
        return eventDataArray;
    }

    public static Event fillEvent(Event event) {
        EventData[] eventDataArray = event.getEventDataArray();
        ArrayList<EventData> original = new ArrayList<EventData>(Arrays.asList(eventDataArray));
        original.addAll(EventFactory.createPrefilledEventDatas());
        event.setEventDataArray(original.toArray(new EventData[0]));
        return event;
    }

    private static String getSessionId() {
        ServletRequest request = ServletRequestContext.getServletRequest();
        if (request != null) {
            HttpServletRequest servletRequest;
            HttpSession session;
            if (request instanceof HttpServletRequest && (session = (servletRequest = (HttpServletRequest)request).getSession(false)) != null) {
                return session.getId();
            }
            LOGGER.debug("No session id is associated with this session");
        }
        return null;
    }

    private static String getTransactionId() {
        try {
            Object transactionKey;
            InitialContext ctx = new InitialContext();
            TransactionSynchronizationRegistry registry = (TransactionSynchronizationRegistry)ctx.lookup("java:comp/TransactionSynchronizationRegistry");
            if (registry != null && (transactionKey = registry.getTransactionKey()) != null) {
                return transactionKey.toString();
            }
        }
        catch (NamingException e) {
            LOGGER.error("javax.naming.NamingException");
        }
        LOGGER.debug("No transaction id is associated with this transaction, defaulting to 0");
        return "0";
    }

    private static String getUserEmail() {
        Long userId = EventFactory.getUserId();
        if (userId != 0L) {
            try {
                return UserLocalServiceUtil.getUserById((long)userId).getEmailAddress();
            }
            catch (PortalException e) {
                LOGGER.debug("No user is associated with this transaction, defaulting to 0");
            }
            catch (SystemException e) {
                LOGGER.debug("No user is associated with this transaction, defaulting to 0");
            }
        }
        return null;
    }

    private static Long getUserId() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long userId = 0L;
        if (permissionChecker == null) {
            LOGGER.debug("No user is associated with this transaction, defaulting to 0");
        } else {
            userId = permissionChecker.getUserId();
        }
        return userId;
    }

    private EventFactory() {
    }
}

