package hu.everit.appserver.utils;

/**
 * Interface that every custom bean locator has to implement.
 * 
 * @author Balazs Zsoldos, Sandor Nemeth
 * 
 */
public interface BeanLocator {

	/**
	 * Returns a unique bean locator ID. This bean locator ID has to be
	 * completely unique throughout the whole application server to be sure that
	 * no bean locators with the different name is registered.
	 * 
	 * @return the bean locator id
	 */
	String getBeanLocatorId();

	/**
	 * This method should return the bean specified with the given name in this
	 * bean locator. The bean name should be unique. The bean must implement at
	 * least one interface which can be discovered through the
	 * {@link java.lang.Class#getInterfaces()} method call.
	 * 
	 * @param name
	 *            the name of the bean to be found in this bean locator
	 * @return the bean
	 */
	Object getBean(String name);

	/**
	 * This method should return the type of the bean specified with the given
	 * bean in this bean locator.
	 * 
	 * @param name
	 *            the name of the bean that's type is requested
	 * @return the most determinable type of the bean
	 */
	Class getBeanType(String name);

}
