package hu.everit.appserver.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderRestoreInvocationHandler implements InvocationHandler {

	private Object obj;

	private ClassLoader objClassLoader;

	public ClassLoaderRestoreInvocationHandler(Object obj) {
		this.obj = obj;
		objClassLoader = obj.getClass().getClassLoader();
	}
	/* (non-Javadoc)
	 * @see java.lang.reflect.InvocationHandler#invoke(java.lang.Object, java.lang.reflect.Method, java.lang.Object[])
	 */
	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {
		Object result = null;
		Thread currentThread = Thread.currentThread();
		ClassLoader originalClassLoader =
			currentThread.getContextClassLoader();
		currentThread.setContextClassLoader(objClassLoader);
		try {
			result = method.invoke(obj, args);
		}catch (InvocationTargetException ex) {
			throw ex.getCause();
		} finally {
			currentThread.setContextClassLoader(originalClassLoader);
		}
		return result;
	}

}