/**
 * 
 */
package hu.everit.appserver.utils.testing;

import hu.everit.appserver.utils.BeanLocator;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * @author sandor.nemeth
 * 
 */
public class TestBeanLocator implements BeanLocator {

	private ApplicationContext appContext = new ClassPathXmlApplicationContext(
			"/applicationContext-test.xml");
	
	/**
	 * @return the appContext
	 */
	public final ApplicationContext getAppContext() {
		return appContext;
	}

	/**
	 * @param appContext the appContext to set
	 */
	public final void setAppContext(ApplicationContext appContext) {
		this.appContext = appContext;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hu.everit.appserver.utils.BeanLocator#getBean(java.lang.String)
	 */
	@Override
	public Object getBean(String name) {
		try {
			return getAppContext().getBean(name);
		} catch (Exception e) {
			
		}
		return null;
		 
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hu.everit.appserver.utils.BeanLocator#getBeanLocatorId()
	 */
	@Override
	public String getBeanLocatorId() {
		return "testBeanLocator1";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hu.everit.appserver.utils.BeanLocator#getBeanType(java.lang.String)
	 */
	@Override
	public Class getBeanType(String name) {
		try {
			return getAppContext().getType(name);
		} catch (Exception e) {
			
		}
		return null;
	}

}
