/*
 * Decompiled with CFR 0.152.
 */
package hu.everit.appserver.utils;

import hu.everit.appserver.utils.BeanLocator;
import hu.everit.appserver.utils.ClassLoaderRestoreInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class BeanLocatorUtil {
    private static Map<String, BeanLocatorEntry> beanLocators = new HashMap<String, BeanLocatorEntry>();
    private static Map<String, Object> beans = new HashMap<String, Object>();
    private static Map<String, Class> beanTypes = new HashMap<String, Class>();
    private static Logger log = Logger.getLogger(BeanLocatorUtil.class.getName());

    public static void addBeanLocator(BeanLocator beanLocator) {
        if (beanLocators.containsKey(beanLocator.getBeanLocatorId())) {
            BeanLocatorUtil.removeBeanLocator(beanLocator.getBeanLocatorId());
            log.warning("There is already a beanLocator with the name " + beanLocator.getBeanLocatorId() + ". Deleting previous instance.");
        }
        beanLocators.put(beanLocator.getBeanLocatorId(), new BeanLocatorEntry(beanLocator));
    }

    public static boolean containsBean(String name) {
        return BeanLocatorUtil.getBean(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getBeanType(String name) {
        Class beanType = beanTypes.get(name);
        Class<BeanLocatorUtil> clazz = BeanLocatorUtil.class;
        synchronized (BeanLocatorUtil.class) {
            if (beanType == null) {
                Iterator<BeanLocatorEntry> iter = beanLocators.values().iterator();
                while (beanType == null && iter.hasNext()) {
                    BeanLocatorEntry ble = iter.next();
                    beanType = ble.beanLocator.getBeanType(name);
                    if (beanType == null) continue;
                    beanTypes.put(name, beanType);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return beanType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getBean(String name) {
        Object entry = beans.get(name);
        Class<BeanLocatorUtil> clazz = BeanLocatorUtil.class;
        synchronized (BeanLocatorUtil.class) {
            if (entry == null) {
                Iterator<BeanLocatorEntry> iter = beanLocators.values().iterator();
                while (entry == null && iter.hasNext()) {
                    BeanLocatorEntry ble = iter.next();
                    entry = ble.beanLocator.getBean(name);
                    if (entry == null) continue;
                    entry = BeanLocatorUtil.wrapObject(entry);
                    beans.put(name, entry);
                    ble.containedBeans.add(name);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return entry;
        }
    }

    public static void removeBeanLocator(BeanLocator beanLocator) {
        BeanLocatorUtil.removeBeanLocator(beanLocator.getBeanLocatorId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBeanLocator(String beanLocatorId) {
        Class<BeanLocatorUtil> clazz = BeanLocatorUtil.class;
        synchronized (BeanLocatorUtil.class) {
            BeanLocatorEntry ble = beanLocators.get(beanLocatorId);
            if (ble != null) {
                Set<String> containedBeans = ble.containedBeans;
                for (String name : containedBeans) {
                    beans.remove(name);
                }
                beanLocators.remove(beanLocatorId);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static Object wrapObject(Object obj) {
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new ClassLoaderRestoreInvocationHandler(obj));
    }

    private static class BeanLocatorEntry {
        public BeanLocator beanLocator;
        public Set<String> containedBeans = new HashSet<String>();

        public BeanLocatorEntry(BeanLocator beanLocator) {
            this.beanLocator = beanLocator;
        }
    }
}

