/*
 * Decompiled with CFR 0.152.
 */
package hu.everit.appserver.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderRestoreInvocationHandler
implements InvocationHandler {
    private Object obj;
    private ClassLoader objClassLoader;

    public ClassLoaderRestoreInvocationHandler(Object obj) {
        this.obj = obj;
        this.objClassLoader = obj.getClass().getClassLoader();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.objClassLoader);
        try {
            try {
                result = method.invoke(this.obj, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
        return result;
    }
}

