/*
 * Decompiled with CFR 0.152.
 */
package com.everit.jpa.jpasupport.annotation.processor;

import com.everit.jpa.jpasupport.annotation.processor.Model;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"javax.persistence.Id", "javax.persistence.Column"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JpaEntityDaoProcessor
extends AbstractProcessor {
    private final Map<String, TypeMirror> classKeys = new HashMap<String, TypeMirror>();

    private void generate(Filer filer, LinkedHashMap<String, Model> models) throws Exception {
        for (String className : models.keySet()) {
            Model model = models.get(className);
            String fullClassName = model.getClassName();
            String packageName = model.getPackageName().substring(0, model.getPackageName().lastIndexOf(".")) + ".dao.generated";
            String onlyClassName = fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
            String onlyFilterClassName = onlyClassName + "Filter";
            String generatedOnlyClassName = "Generated" + onlyClassName + "Dao";
            String generatedFullClassName = packageName + "." + generatedOnlyClassName;
            System.out.println("+++ generating " + generatedFullClassName);
            JavaFileObject javaFileObject = filer.createSourceFile(generatedFullClassName, new Element[0]);
            Writer writer = javaFileObject.openWriter();
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            writer.write("import com.everit.jpa.jpasupport.dao.GenericDao;\n");
            writer.write("import " + fullClassName + ";\n");
            writer.write("import " + fullClassName + "Filter;\n");
            writer.write("\n");
            writer.write("/* Generated on " + new Date() + " by JpaEntityDaoProcessor */\n");
            writer.write("\n");
            Iterator<Name> idsIterator = model.getIds().keySet().iterator();
            Name name = idsIterator.next();
            TypeMirror typeMirror = model.getIds().get(name);
            String keyType = ((Object)typeMirror).toString();
            writer.write("public interface " + generatedOnlyClassName + " extends GenericDao<" + onlyClassName + ", " + onlyFilterClassName + ", " + keyType + "> { \n");
            writer.write("\n");
            writer.write("} \n");
            writer.flush();
            writer.close();
        }
    }

    private void generateImpl(Filer filer, LinkedHashMap<String, Model> models) throws Exception {
        for (String className : models.keySet()) {
            Model model = models.get(className);
            String fullClassName = model.getClassName();
            String packageName = model.getPackageName().substring(0, model.getPackageName().lastIndexOf(".")) + ".dao.generated.impl";
            String interfacePackageName = model.getPackageName().substring(0, model.getPackageName().lastIndexOf(".")) + ".dao.generated";
            String onlyClassName = fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
            String onlyFilterClassName = onlyClassName + "Filter";
            String interfaceOnlyClassName = "Generated" + onlyClassName + "Dao";
            String generatedOnlyClassName = "Generated" + onlyClassName + "JpaDaoImpl";
            String generatedFullClassName = packageName + "." + generatedOnlyClassName;
            String interfaceFullClassName = interfacePackageName + "." + interfaceOnlyClassName;
            System.out.println("+++ generating " + generatedFullClassName);
            JavaFileObject javaFileObject = filer.createSourceFile(generatedFullClassName, new Element[0]);
            Writer writer = javaFileObject.openWriter();
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            writer.write("import javax.persistence.criteria.Predicate;\n");
            writer.write("import javax.persistence.criteria.Path;\n");
            writer.write("import com.everit.jpa.jpasupport.dao.impl.GenericJpaDaoImpl;\n");
            writer.write("import " + interfaceFullClassName + ";\n");
            writer.write("import " + fullClassName + ";\n");
            writer.write("import " + fullClassName + "Filter;\n");
            writer.write("import " + fullClassName + "_;\n");
            writer.write("import javax.persistence.criteria.CriteriaBuilder;\n");
            for (TypeMirror type : model.getTypes()) {
                if (((Object)type).toString().startsWith("java.lang.")) continue;
                writer.write("import " + type + ";\n");
            }
            writer.write("\n");
            writer.write("/* Generated on " + new Date() + " by JpaEntityDaoImplProcessor */\n");
            writer.write("\n");
            Iterator<Name> idsIterator = model.getIds().keySet().iterator();
            Name name2 = idsIterator.next();
            TypeMirror typeMirror2 = model.getIds().get(name2);
            String keyType = ((Object)typeMirror2).toString();
            writer.write("public abstract class " + generatedOnlyClassName + " extends GenericJpaDaoImpl<" + onlyClassName + ", " + onlyFilterClassName + ", " + keyType + "> implements " + interfaceOnlyClassName + " { \n");
            writer.write("\n");
            writer.write("\tpublic " + generatedOnlyClassName + "(){\n");
            writer.write("\t\t super(" + onlyClassName + ".class);\n\t}\n\n");
            Iterator<Name> membersIterator = model.getIds().keySet().iterator();
            while (membersIterator.hasNext()) {
                Name name = membersIterator.next();
                String attributeNameCamel = name.toString().toUpperCase().substring(0, 1).concat(name.toString().substring(1));
                TypeMirror typeMirror = model.getIds().get(name);
                if (this.getSimpleClassName(((Object)typeMirror).toString()).equals("Long")) {
                    writer.write("\t//----------------" + attributeNameCamel + "----------------\n");
                    writer.write("\tprotected Predicate in" + attributeNameCamel + "Interval(final Path<" + onlyClassName + "> " + onlyClassName.toLowerCase() + ", final Long lowerBound, final Long upperBound){");
                    writer.write("\n");
                    writer.write("\t\tCriteriaBuilder cb=em.getCriteriaBuilder();\n");
                    writer.write("\t\tPredicate predicate = cb.conjunction();\n");
                    writer.write("\t\tif (lowerBound == null && upperBound==null) {\n");
                    writer.write("\t\t\treturn predicate;\n");
                    writer.write("\t\t}\n");
                    writer.write("\t\tif (lowerBound != null){\n");
                    writer.write("\t\t\tpredicate = cb.and(predicate, cb.greaterThanOrEqualTo(");
                    writer.write(onlyClassName.toLowerCase() + ".get(" + onlyClassName + "_." + name + "), lowerBound));\n\t\t}\n");
                    writer.write("\t\tif (upperBound != null){\n");
                    writer.write("\t\t\tpredicate = cb.and(predicate, cb.lessThanOrEqualTo(");
                    writer.write(onlyClassName.toLowerCase() + ".get(" + onlyClassName + "_." + name + "), upperBound));\n\t\t}\n");
                    writer.write("\t\treturn predicate;\n\t}\n");
                    writer.write("\n");
                    writer.write("\t//----------------" + attributeNameCamel + "----------------\n");
                    writer.write("\tprotected Predicate " + name + "Equals(final Path<" + onlyClassName + "> " + onlyClassName.toLowerCase() + ", final Long statement){");
                    writer.write("\n");
                    writer.write("\t\tCriteriaBuilder cb=em.getCriteriaBuilder();\n");
                    writer.write("\t\tPredicate predicate = cb.conjunction();\n");
                    writer.write("\t\tif (statement == null) {\n");
                    writer.write("\t\t\treturn predicate;\n");
                    writer.write("\t\t}\n");
                    writer.write("\t\telse {\n");
                    writer.write("\t\t\tpredicate = cb.and(predicate, cb.equal(");
                    writer.write(onlyClassName.toLowerCase() + ".get(" + onlyClassName + "_." + name + "), statement));\n\t\t}\n");
                    writer.write("\t\treturn predicate;\n\t}\n");
                }
                if (this.getSimpleClassName(((Object)typeMirror).toString()).equals("Date")) {
                    writer.write("\t//----------------" + attributeNameCamel + "----------------\n");
                    writer.write("\tprotected Predicate in" + attributeNameCamel + "Interval(final Path<" + onlyClassName + "> " + onlyClassName.toLowerCase() + ", final Date lowerBound, final Date upperBound){");
                    writer.write("\n");
                    writer.write("\t\tCriteriaBuilder cb=em.getCriteriaBuilder();\n");
                    writer.write("\t\tPredicate predicate = cb.conjunction();\n");
                    writer.write("\t\tif (lowerBound == null && upperBound==null) {\n");
                    writer.write("\t\t\treturn predicate;\n");
                    writer.write("\t\t}\n");
                    writer.write("\t\tif (lowerBound != null){\n");
                    writer.write("\t\t\tpredicate = cb.and(predicate, cb.greaterThanOrEqualTo(");
                    writer.write(onlyClassName.toLowerCase() + ".get(" + onlyClassName + "_." + name + "), lowerBound));\n\t\t}\n");
                    writer.write("\t\tif (upperBound != null){\n");
                    writer.write("\t\t\tpredicate = cb.and(predicate, cb.lessThanOrEqualTo(");
                    writer.write(onlyClassName.toLowerCase() + ".get(" + onlyClassName + "_." + name + "), upperBound));\n\t\t}\n");
                    writer.write("\t\treturn predicate;\n\t}\n");
                    writer.write("\n");
                    writer.write("\t//----------------" + attributeNameCamel + "----------------\n");
                    writer.write("\tprotected Predicate " + name + "Equals(final Path<" + onlyClassName + "> " + onlyClassName.toLowerCase() + ", final Date statement){");
                    writer.write("\n");
                    writer.write("\t\tCriteriaBuilder cb=em.getCriteriaBuilder();\n");
                    writer.write("\t\tPredicate predicate = cb.conjunction();\n");
                    writer.write("\t\tif (statement == null) {\n");
                    writer.write("\t\t\treturn predicate;\n");
                    writer.write("\t\t}\n");
                    writer.write("\t\telse {\n");
                    writer.write("\t\t\tpredicate = cb.and(predicate, cb.equal(");
                    writer.write(onlyClassName.toLowerCase() + ".get(" + onlyClassName + "_." + name + "), statement));\n\t\t}\n");
                    writer.write("\t\treturn predicate;\n\t}\n");
                }
                if (this.getSimpleClassName(((Object)typeMirror).toString()).equals("String")) {
                    writer.write("\t//----------------" + attributeNameCamel + "----------------\n");
                    writer.write("\tprotected Predicate " + name + "Contains(final Path<" + onlyClassName + "> " + onlyClassName.toLowerCase() + ", final String statement){");
                    writer.write("\n");
                    writer.write("\t\tCriteriaBuilder cb=em.getCriteriaBuilder();\n");
                    writer.write("\t\tPredicate predicate = cb.conjunction();\n");
                    writer.write("\t\tif (statement == null) {\n");
                    writer.write("\t\t\treturn predicate;\n");
                    writer.write("\t\t} else {\n");
                    writer.write("\t\t\tpredicate = cb.and(predicate, cb.like(");
                    writer.write(onlyClassName.toLowerCase() + ".get(" + onlyClassName + "_." + name + "), \"%\" + statement + \"%\"));\n\t\t}\n");
                    writer.write("\t\treturn predicate;\n\t}\n");
                    writer.write("\n");
                    writer.write("\t//----------------" + attributeNameCamel + "----------------\n");
                    writer.write("\tprotected Predicate " + name + "DoesNotContain(final Path<" + onlyClassName + "> " + onlyClassName.toLowerCase() + ", final String statement){");
                    writer.write("\n");
                    writer.write("\t\tCriteriaBuilder cb=em.getCriteriaBuilder();\n");
                    writer.write("\t\tPredicate predicate = cb.conjunction();\n");
                    writer.write("\t\tif (statement == null) {\n");
                    writer.write("\t\t\treturn predicate;\n");
                    writer.write("\t\t}\n");
                    writer.write("\t\telse {\n");
                    writer.write("\t\t\tpredicate = cb.and(predicate, cb.notLike(");
                    writer.write(onlyClassName.toLowerCase() + ".get(" + onlyClassName + "_." + name + "), \"%\" + statement + \"%\"));\n\t\t}\n");
                    writer.write("\t\treturn predicate;\n\t}\n");
                }
                if (!membersIterator.hasNext()) continue;
                writer.write("\n");
            }
            writer.write("} \n");
            writer.flush();
            writer.close();
        }
    }

    private String getSimpleClassName(String fullClassName) {
        return fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        System.out.println("++++++ generating predicate factory for interfaces for jpa dao classes");
        Messager messager = this.processingEnv.getMessager();
        LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.processAnnotation(typeElement, element, models);
            }
        }
        if (models.size() > 0) {
            try {
                for (String string : models.keySet()) {
                    Model model = models.get(string);
                    for (Name idName : model.getIds().keySet()) {
                        model.getColumns().remove(idName);
                    }
                }
                this.generate(this.processingEnv.getFiler(), models);
                this.generateImpl(this.processingEnv.getFiler(), models);
            }
            catch (Exception e) {
                messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        System.out.println("++++++ generation complete");
        return true;
    }

    private void processAnnotation(TypeElement typeElement, Element element, LinkedHashMap<String, Model> models) {
        String cn = element.getEnclosingElement().toString();
        Model model = models.get(cn);
        if (model == null) {
            String className = cn;
            String packageName = cn.substring(0, cn.lastIndexOf("."));
            model = new Model(className, packageName);
            models.put(className, model);
        }
        if (typeElement.toString().equals("javax.persistence.Id") || typeElement.toString().equals("javax.persistence.Column")) {
            model.getIds().put(element.getSimpleName(), element.asType());
            this.classKeys.put(model.getClassName(), element.asType());
            model.getTypes().add(element.asType());
        } else {
            model.getColumns().put(element.getSimpleName(), element.asType());
            model.getTypes().add(element.asType());
        }
    }
}

