/*
 * Decompiled with CFR 0.152.
 */
package com.everit.jpa.jpasupport.annotation.processor;

import com.everit.jpa.jpasupport.annotation.processor.Model;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column", "javax.persistence.Version", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JpaEntityFilterProcessor
extends AbstractProcessor {
    private Map<TypeMirror, String> typeMirrorMapping = new HashMap<TypeMirror, String>();
    private LinkedHashMap<String, Model> models = new LinkedHashMap();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        System.out.println("++++++ generating DAO filters for entities");
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                String typeElementAsString = typeElement.toString();
                if (typeElementAsString.equals("javax.persistence.Entity")) {
                    this.getModelByEntityElement(element);
                    continue;
                }
                if (typeElementAsString.equals("javax.persistence.Id")) {
                    this.processElement(element, this.getModelByEntityElement(element.getEnclosingElement()).getIds());
                    continue;
                }
                if (typeElementAsString.equals("javax.persistence.Column")) {
                    this.processElement(element, this.getModelByEntityElement(element.getEnclosingElement()).getColumns());
                    continue;
                }
                if (typeElementAsString.equals("javax.persistence.Version")) {
                    this.processElement(element, this.getModelByEntityElement(element.getEnclosingElement()).getVersions());
                    continue;
                }
                if (!typeElementAsString.equals("javax.persistence.OneToOne") && !typeElementAsString.equals("javax.persistence.ManyToOne") && !typeElementAsString.equals("javax.persistence.OneToMany")) continue;
                this.processElement(element, this.getModelByEntityElement(element.getEnclosingElement()).getAssociations());
            }
        }
        this.cleanModels();
        this.createHierarchy();
        try {
            this.generateCode();
        }
        catch (FilerException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void cleanModels() {
        for (String className : this.models.keySet()) {
            Model model = this.models.get(className);
            for (Name idName : model.getIds().keySet()) {
                model.getColumns().remove(idName);
            }
            for (Name mapsIdName : model.getMapsIds().keySet()) {
                model.getAssociations().remove(mapsIdName);
                model.getColumns().remove(mapsIdName);
            }
            for (Name versionName : model.getVersions().keySet()) {
                model.getColumns().remove(versionName);
            }
            Iterator<Name> assocIterator = model.getAssociations().keySet().iterator();
            while (assocIterator.hasNext()) {
                Name assocName = assocIterator.next();
                if (!model.getIds().containsKey(assocName)) continue;
                assocIterator.remove();
            }
        }
    }

    private void generateCode() throws IOException {
        for (String className : this.models.keySet()) {
            Model model = this.models.get(className);
            String qualifiedClassName = model.getClassName();
            String packageName = model.getPackageName();
            String onlyClassName = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1, qualifiedClassName.length());
            String generatedOnlyClassName = onlyClassName + "Filter";
            String qualifiedFullClassName = packageName + "." + generatedOnlyClassName;
            System.out.println("### generating " + qualifiedFullClassName);
            JavaFileObject javaFileObject = this.processingEnv.getFiler().createSourceFile(qualifiedFullClassName, new Element[0]);
            Writer writer = javaFileObject.openWriter();
            writer.write("package " + model.getPackageName() + ";\n");
            writer.write("\n");
            writer.write("\n");
            writer.write("@javax.annotation.Generated(value = \"" + this.getClass().getName() + "\", date = \"" + new java.util.Date() + "\")\n");
            writer.write("public class " + generatedOnlyClassName);
            if (model.hasParentClassName()) {
                writer.write(" extends " + model.getParentClassName() + "Filter");
            }
            writer.write(" { \n");
            writer.write("\n");
            String andSearchFieldName = "andSearch";
            if (!model.hasParentClassName()) {
                this.generateFieldWithGetterAndSetter(writer, "java.lang.Boolean", andSearchFieldName);
            }
            writer.write("\tpublic " + generatedOnlyClassName + "() {\n");
            if (!model.hasParentClassName()) {
                writer.write("\t\tthis." + andSearchFieldName + " = java.lang.Boolean.TRUE;\n");
                writer.write("\t}\n");
                writer.write("\tpublic " + generatedOnlyClassName + "(final java.lang.Boolean " + andSearchFieldName + ") {\n");
                writer.write("\t\tthis." + andSearchFieldName + " = " + andSearchFieldName + ";\n");
            } else {
                writer.write("\t\tsuper();\n");
                writer.write("\t}\n");
                writer.write("\tpublic " + generatedOnlyClassName + "(final java.lang.Boolean " + andSearchFieldName + ") {\n");
                writer.write("\t\tsuper(" + andSearchFieldName + ");\n");
            }
            writer.write("\t}\n");
            this.generateIdFilters(writer, model.getIds());
            this.generateColumnFilters(writer, model.getColumns());
            this.generateAssociationFilters(writer, model.getAssociations());
            writer.write("\n");
            writer.write("} \n");
            writer.flush();
            writer.close();
        }
    }

    private void generateAssociationFilters(Writer writer, LinkedHashMap<Name, TypeMirror> associations) throws IOException {
        for (Name assocName : associations.keySet()) {
            TypeMirror assocType = associations.get(assocName);
            String assocTypeAsString = this.typeMirrorMapping.get(assocType);
            int genericIndex = assocTypeAsString.lastIndexOf("<");
            String genericType = "java.lang.Object";
            if (genericIndex != -1) {
                genericType = assocTypeAsString.substring(genericIndex + 1, assocTypeAsString.length() - 1);
                assocTypeAsString = assocTypeAsString.substring(0, genericIndex);
            }
            if (assocTypeAsString.equals(List.class.toString()) || assocTypeAsString.equals(Set.class.toString())) {
                this.generateFieldWithGetterAndSetter(writer, "java.util.List<" + genericType + "Filter>", assocName + "In");
                this.generateGetterAndSetterForInEq(writer, genericType.toString(), assocName.toString());
                continue;
            }
            this.generateFieldWithGetterAndSetter(writer, "java.util.List<java.lang.Long>", assocName + "In");
            this.generateGetterAndSetterForInEq(writer, "java.lang.Long", assocName.toString());
        }
    }

    private void generateColumnFilters(Writer writer, LinkedHashMap<Name, TypeMirror> columns) throws IOException {
        for (Name columnName : columns.keySet()) {
            TypeMirror columnType = columns.get(columnName);
            String columTypeAsString = this.typeMirrorMapping.get(columnType);
            FilterType filterType = this.getColumnFilterType(columnType);
            if (FilterType.LOW_HIGH.equals((Object)filterType)) {
                this.generateFieldWithGetterAndSetter(writer, columTypeAsString.toString(), columnName + "Low");
                this.generateFieldWithGetterAndSetter(writer, columTypeAsString.toString(), columnName + "High");
                continue;
            }
            if (FilterType.LIKE.equals((Object)filterType) || FilterType.EQ.equals((Object)filterType)) {
                this.generateFieldWithGetterAndSetter(writer, columTypeAsString.toString(), columnName + "Like");
                continue;
            }
            if (FilterType.IN_TYPE.equals((Object)filterType)) {
                this.generateFieldWithGetterAndSetter(writer, "java.util.List<" + columTypeAsString + ">", columnName + "In");
                this.generateGetterAndSetterForInEq(writer, columTypeAsString.toString(), columnName.toString());
                continue;
            }
            this.generateFieldWithGetterAndSetter(writer, "java.util.List<java.lang.Long>", columnName + "In");
            this.generateGetterAndSetterForInEq(writer, "java.lang.Long", columnName.toString());
        }
    }

    private void generateFieldWithGetterAndSetter(Writer writer, String fieldType, String fieldName) throws IOException {
        this.generateField(writer, fieldType, fieldName);
        this.generateGetterAndSetter(writer, fieldType, fieldName);
    }

    private void generateGetterAndSetter(Writer writer, String fieldType, String fieldName) throws IOException {
        String capitalFieldName = this.firstCapital(fieldName);
        writer.write("\tpublic " + fieldType + " get" + capitalFieldName + "() {\n");
        writer.write("\t\treturn " + fieldName + ";\n");
        writer.write("\t}\n");
        writer.write("\tpublic void set" + capitalFieldName + "(final " + fieldType + " " + fieldName + ") {\n");
        writer.write("\t\tthis." + fieldName + " = " + fieldName + ";\n");
        writer.write("\t}\n");
    }

    private void generateGetterAndSetterForInEq(Writer writer, String fieldType, String fieldName) throws IOException {
        String capitalFieldName = this.firstCapital(fieldName);
        String fieldNameIn = fieldName + "In";
        writer.write("\tpublic " + fieldType + " get" + capitalFieldName + "Eq() {\n");
        writer.write("\t\tif ((" + fieldNameIn + " == null) || " + fieldNameIn + ".isEmpty()) {\n");
        writer.write("\t\t\treturn null;\n");
        writer.write("\t\t}\n");
        writer.write("\t\tif (" + fieldNameIn + ".size() > 1) {\n");
        writer.write("\t\t\tthrow new java.lang.IndexOutOfBoundsException(\"Size must be 0 or 1!\");\n");
        writer.write("\t\t}\n");
        writer.write("\t\treturn " + fieldNameIn + ".get(0);\n");
        writer.write("\t}\n");
        writer.write("\tpublic void set" + capitalFieldName + "Eq(final " + fieldType + " " + fieldNameIn + ") {\n");
        writer.write("\t\tif (" + fieldNameIn + " != null) {\n");
        writer.write("\t\t\tthis." + fieldNameIn + " = new java.util.ArrayList<" + fieldType + ">();\n");
        writer.write("\t\t\tthis." + fieldNameIn + ".add(" + fieldNameIn + ");\n");
        writer.write("\t\t} else {\n");
        writer.write("\t\t\tthis." + fieldNameIn + " = null;\n");
        writer.write("\t\t}\n");
        writer.write("\t}\n");
    }

    private void generateField(Writer writer, String fieldType, String fieldName) throws IOException {
        writer.write("\tprivate " + fieldType + " " + fieldName + " = null;\n");
    }

    private String firstCapital(String text) {
        String firstCapital = text.substring(0, 1).toUpperCase();
        return firstCapital + text.substring(1);
    }

    private FilterType getColumnFilterType(TypeMirror columnType) {
        String columnTypeAsString = this.typeMirrorMapping.get(columnType);
        if (columnTypeAsString == null) {
            throw new NullPointerException("columnType is not mapped for " + ((Object)columnType).toString());
        }
        if (BigDecimal.class.getName().equals(columnTypeAsString) || BigInteger.class.getName().equals(columnTypeAsString) || Byte.class.getName().equals(columnTypeAsString) || Double.class.getName().equals(columnTypeAsString) || Float.class.getName().equals(columnTypeAsString) || Integer.class.getName().equals(columnTypeAsString) || Long.class.getName().equals(columnTypeAsString) || Short.class.getName().equals(columnTypeAsString) || java.util.Date.class.getName().equals(columnTypeAsString) || Date.class.getName().equals(columnTypeAsString) || Time.class.getName().equals(columnTypeAsString) || Timestamp.class.getName().equals(columnTypeAsString)) {
            return FilterType.LOW_HIGH;
        }
        if (String.class.getName().equals(columnTypeAsString)) {
            return FilterType.LIKE;
        }
        if (Boolean.class.getName().equals(columnTypeAsString)) {
            return FilterType.EQ;
        }
        return FilterType.IN_TYPE;
    }

    private void generateIdFilters(Writer writer, LinkedHashMap<Name, TypeMirror> ids) throws IOException {
        for (Name idName : ids.keySet()) {
            TypeMirror idType = ids.get(idName);
            String idTypeAsString = this.typeMirrorMapping.get(idType);
            if (idTypeAsString == null) {
                throw new NullPointerException("id is not mapped for " + ((Object)idType).toString());
            }
            this.generateFieldWithGetterAndSetter(writer, idTypeAsString, idName + "Eq");
        }
    }

    private void createHierarchy() {
        Types typeUtils = this.processingEnv.getTypeUtils();
        for (String parentClass : this.models.keySet()) {
            Model parentModel = this.models.get(parentClass);
            List<? extends TypeMirror> directSupertypes = typeUtils.directSupertypes(parentModel.getTypeMirror());
            for (TypeMirror typeMirror : directSupertypes) {
                String typeMirrorAsString = this.typeMirrorMapping.get(typeMirror);
                if (typeMirrorAsString == null) {
                    typeMirrorAsString = ((Object)typeMirror).toString();
                }
                if (Object.class.getName().equals(typeMirrorAsString) || Serializable.class.getName().equals(typeMirrorAsString)) continue;
                parentModel.setParentClassName(typeMirrorAsString);
            }
        }
    }

    private void processElement(Element element, LinkedHashMap<Name, TypeMirror> map) {
        TypeMirror typeMirror = element.asType();
        this.initTypeMirrorMapping(typeMirror);
        map.put(element.getSimpleName(), typeMirror);
    }

    private void initTypeMirrorMapping(TypeMirror typeMirror) {
        if (!this.typeMirrorMapping.containsKey(typeMirror)) {
            String typeMirrorAsString = ((Object)typeMirror).toString();
            if (typeMirrorAsString.equals("short")) {
                typeMirrorAsString = Short.class.getName();
            } else if (typeMirrorAsString.equals("long")) {
                typeMirrorAsString = Long.class.getName();
            } else if (typeMirrorAsString.equals("byte")) {
                typeMirrorAsString = Byte.class.getName();
            } else if (typeMirrorAsString.equals("double")) {
                typeMirrorAsString = Double.class.getName();
            } else if (typeMirrorAsString.equals("int")) {
                typeMirrorAsString = Integer.class.getName();
            } else if (typeMirrorAsString.equals("boolean")) {
                typeMirrorAsString = Boolean.class.getName();
            } else if (typeMirrorAsString.equals("float")) {
                typeMirrorAsString = Float.class.getName();
            }
            this.typeMirrorMapping.put(typeMirror, typeMirrorAsString);
        }
    }

    private Model getModelByEntityElement(Element entityElement) {
        String className = entityElement.toString();
        Model model = this.models.get(className);
        if (model == null) {
            model = new Model(className);
            model.setTypeMirror(entityElement.asType());
            model.setElement(entityElement);
            this.models.put(className, model);
        }
        return model;
    }

    static enum FilterType {
        EQ,
        LIKE,
        LOW_HIGH,
        IN_TYPE,
        IN_IDS;

    }
}

