/*
 * Decompiled with CFR 0.152.
 */
package com.everit.jpa.jpasupport.annotation.processor;

import com.everit.jpa.jpasupport.annotation.processor.Model;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"javax.persistence.Id", "javax.persistence.Version", "javax.persistence.Column", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.MapsId"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JpaServiceApiProcessor
extends AbstractProcessor {
    private Map<String, TypeMirror> classKeys = new HashMap<String, TypeMirror>();

    private void createModel(Model model, String onlyClassName, Writer writer) throws IOException {
        writer.write("\t" + onlyClassName + " create" + onlyClassName + "(\n");
        Iterator<Name> columnsIterator = model.getColumns().keySet().iterator();
        Iterator<Name> assocIterator = model.getAssociations().keySet().iterator();
        while (columnsIterator.hasNext()) {
            Name columnName = columnsIterator.next();
            TypeMirror columnTypeMirror = model.getColumns().get(columnName);
            writer.write("\t\tfinal " + this.getSimpleClassName(((Object)columnTypeMirror).toString()) + " " + columnName);
            if (!columnsIterator.hasNext() && !assocIterator.hasNext()) continue;
            writer.write(",\n");
        }
        while (assocIterator.hasNext()) {
            Name assocName = assocIterator.next();
            TypeMirror typeMirror = model.getAssociations().get(assocName);
            TypeMirror classKey = this.classKeys.get(((Object)typeMirror).toString());
            if (classKey == null) {
                writer.write("\t\tfinal " + this.getSimpleClassName(((Object)typeMirror).toString()) + " " + assocName);
            } else {
                writer.write("\t\tfinal " + this.getSimpleClassName(((Object)classKey).toString()) + " " + assocName + "Id");
            }
            if (!assocIterator.hasNext()) continue;
            writer.write(",\n");
        }
        writer.write("\n\t);\n\n");
    }

    private void delete(Model model, String onlyClassName, Writer writer) throws IOException {
        writer.write("\tvoid delete" + onlyClassName + "(\n");
        Iterator<Name> idsIterator = model.getIds().keySet().iterator();
        Iterator<Name> versionsIterator = model.getVersions().keySet().iterator();
        while (idsIterator.hasNext()) {
            Name idName = idsIterator.next();
            TypeMirror idTypeMirror = model.getIds().get(idName);
            writer.write("\t\tfinal " + this.getSimpleClassName(((Object)idTypeMirror).toString()) + " " + idName);
            if (!idsIterator.hasNext() && !versionsIterator.hasNext()) continue;
            writer.write(",\n");
        }
        while (versionsIterator.hasNext()) {
            Name versionName = versionsIterator.next();
            TypeMirror versionTypeMirror = model.getVersions().get(versionName);
            writer.write("\t\tfinal " + this.getSimpleClassName(((Object)versionTypeMirror).toString()) + " " + versionName);
            if (!versionsIterator.hasNext()) continue;
            writer.write(",\n");
        }
        writer.write("\n\t);\n\n");
    }

    private void generate(Filer filer, LinkedHashMap<String, Model> models) throws Exception {
        for (String className : models.keySet()) {
            Model model = models.get(className);
            String qualifiedClassName = model.getClassName();
            String packageName = model.getPackageName();
            String onlyClassName = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1, qualifiedClassName.length());
            String qualifiedFullClassName = packageName + ".Generated" + onlyClassName + "Service";
            String generatedOnlyClassName = "Generated" + onlyClassName + "Service";
            System.out.println("+++ generating " + qualifiedFullClassName);
            JavaFileObject javaFileObject = filer.createSourceFile(qualifiedFullClassName, new Element[0]);
            Writer writer = javaFileObject.openWriter();
            writer.write("package " + model.getPackageName() + ";\n");
            writer.write("\n");
            this.imports(model, qualifiedClassName, writer);
            writer.write("\n");
            writer.write("@Generated(value = \"" + this.getClass().getName() + "\", date = \"" + new Date() + "\")\n");
            writer.write("public interface " + generatedOnlyClassName + " { \n");
            writer.write("\n");
            this.createModel(model, onlyClassName, writer);
            this.update(model, onlyClassName, writer);
            this.read(model, onlyClassName, writer);
            this.delete(model, onlyClassName, writer);
            writer.write("} \n");
            writer.flush();
            writer.close();
        }
    }

    private void getImports(Model model, Collection<TypeMirror> typeMirrors) {
        for (TypeMirror typeMirror : typeMirrors) {
            TypeMirror classKey = this.classKeys.get(((Object)typeMirror).toString());
            if (classKey != null) continue;
            model.getTypes().add(typeMirror);
        }
    }

    private String getSimpleClassName(String fullClassName) {
        return fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
    }

    private void imports(Model model, String qualifiedClassName, Writer writer) throws IOException {
        this.getImports(model, model.getAssociations().values());
        this.getImports(model, model.getColumns().values());
        this.getImports(model, model.getIds().values());
        this.getImports(model, model.getMapsIds().values());
        this.getImports(model, model.getVersions().values());
        writer.write("import javax.annotation.Generated;\n");
        writer.write("import " + qualifiedClassName + ";\n");
        for (TypeMirror type : model.getTypes()) {
            writer.write("import " + type + ";\n");
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        System.out.println("++++++ generating service interfaces for jpa model classes");
        Messager messager = this.processingEnv.getMessager();
        LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.processAnnotation(typeElement, element, models);
            }
        }
        if (models.size() > 0) {
            try {
                for (String string : models.keySet()) {
                    Model model = models.get(string);
                    for (Name idName : model.getIds().keySet()) {
                        model.getColumns().remove(idName);
                    }
                    for (Name mapsIdName : model.getMapsIds().keySet()) {
                        model.getAssociations().remove(mapsIdName);
                        model.getColumns().remove(mapsIdName);
                    }
                    for (Name versionName : model.getVersions().keySet()) {
                        model.getColumns().remove(versionName);
                    }
                    Iterator<Name> iterator = model.getAssociations().keySet().iterator();
                    while (iterator.hasNext()) {
                        Name assocName = iterator.next();
                        if (!model.getIds().containsKey(assocName)) continue;
                        iterator.remove();
                    }
                }
                this.generate(this.processingEnv.getFiler(), models);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        System.out.println("++++++ generation complete");
        return true;
    }

    private void processAnnotation(TypeElement typeElement, Element element, LinkedHashMap<String, Model> models) {
        String cn = element.getEnclosingElement().toString();
        Model model = models.get(cn);
        if (model == null) {
            String className = cn;
            String packageName = cn.substring(0, cn.lastIndexOf("."));
            model = new Model(className, packageName);
            models.put(className, model);
        }
        if (typeElement.toString().equals("javax.persistence.Id")) {
            model.getIds().put(element.getSimpleName(), element.asType());
            this.classKeys.put(model.getClassName(), element.asType());
            model.getTypes().add(element.asType());
        } else if (typeElement.toString().equals("javax.persistence.Version")) {
            model.getVersions().put(element.getSimpleName(), element.asType());
            model.getTypes().add(element.asType());
        } else if (typeElement.toString().equals("javax.persistence.OneToOne") || typeElement.toString().equals("javax.persistence.ManyToOne")) {
            model.getAssociations().put(element.getSimpleName(), element.asType());
        } else if (typeElement.toString().equals("javax.persistence.Column")) {
            model.getColumns().put(element.getSimpleName(), element.asType());
            model.getTypes().add(element.asType());
        } else if (typeElement.toString().equals("javax.persistence.MapsId")) {
            model.getMapsIds().put(element.getSimpleName(), element.asType());
        }
    }

    private void read(Model model, String onlyClassName, Writer writer) throws IOException {
        writer.write("\t" + onlyClassName + " read" + onlyClassName + "(\n");
        Iterator<Name> idsIterator = model.getIds().keySet().iterator();
        while (idsIterator.hasNext()) {
            Name name = idsIterator.next();
            TypeMirror typeMirror = model.getIds().get(name);
            writer.write("\t\tfinal " + this.getSimpleClassName(((Object)typeMirror).toString()) + " " + name);
            if (!idsIterator.hasNext()) continue;
            writer.write(",\n");
        }
        writer.write("\n\t);\n\n");
    }

    private void update(Model model, String onlyClassName, Writer writer) throws IOException {
        if (!model.getColumns().isEmpty()) {
            writer.write("\t" + onlyClassName + " update" + onlyClassName + "(\n");
            Iterator<Name> idsIterator = model.getIds().keySet().iterator();
            Iterator<Name> versionsIterator = model.getVersions().keySet().iterator();
            Iterator<Name> columnsIterator = model.getColumns().keySet().iterator();
            while (idsIterator.hasNext()) {
                Name idName = idsIterator.next();
                TypeMirror idTypeMirror = model.getIds().get(idName);
                writer.write("\t\tfinal " + this.getSimpleClassName(((Object)idTypeMirror).toString()) + " " + idName);
                if (!idsIterator.hasNext() && !versionsIterator.hasNext() && !columnsIterator.hasNext()) continue;
                writer.write(",\n");
            }
            while (versionsIterator.hasNext()) {
                Name versionName = versionsIterator.next();
                TypeMirror versionTypeMirror = model.getVersions().get(versionName);
                writer.write("\t\tfinal " + this.getSimpleClassName(((Object)versionTypeMirror).toString()) + " " + versionName);
                if (!versionsIterator.hasNext() && !columnsIterator.hasNext()) continue;
                writer.write(",\n");
            }
            while (columnsIterator.hasNext()) {
                Name columnName = columnsIterator.next();
                TypeMirror columnTypeMirror = model.getColumns().get(columnName);
                writer.write("\t\tfinal " + this.getSimpleClassName(((Object)columnTypeMirror).toString()) + " " + columnName);
                if (!columnsIterator.hasNext()) continue;
                writer.write(",\n");
            }
            writer.write("\n\t);\n\n");
        }
    }
}

