/*
 * Decompiled with CFR 0.152.
 */
package com.everit.jpa.jpasupport.dao.impl;

import com.everit.jpa.jpasupport.dao.GenericDao;
import com.everit.jpa.jpasupport.dao.orderby.AbstractOrderBy;
import com.everit.jpa.jpasupport.dao.orderby.OrderByList;
import com.everit.jpa.jpasupport.dao.orderby.OrderByUtil;
import com.everit.jpa.jpasupport.filter.ExtendedFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.transaction.annotation.Transactional;

public abstract class GenericJpaDaoImpl<T, F, PK extends Serializable>
implements GenericDao<T, F, PK> {
    @PersistenceContext
    protected EntityManager em = null;
    protected Class<T> type = null;

    public GenericJpaDaoImpl(Class<T> type) {
        this.type = type;
    }

    protected CriteriaQuery<T> addOrderBy(Root<T> root, CriteriaQuery<T> criteriaQuery, OrderByList<? extends AbstractOrderBy<?>> orderByList) {
        if (orderByList != null && orderByList.size() > 0) {
            if (orderByList.get(0) == null || ((AbstractOrderBy)orderByList.get(0)).isNull()) {
                return criteriaQuery;
            }
            CriteriaBuilder cb = this.em.getCriteriaBuilder();
            ArrayList<Order> orders = new ArrayList<Order>(orderByList.size());
            for (AbstractOrderBy orderBy : orderByList) {
                orders.add(OrderByUtil.getOrder(orderBy, cb, root));
            }
            criteriaQuery.orderBy(orders);
        }
        return criteriaQuery;
    }

    protected TypedQuery<T> addPagination(TypedQuery<T> typedQuery, int firstResult, int maxResults) {
        typedQuery.setFirstResult(firstResult);
        if (maxResults > 0) {
            typedQuery.setMaxResults(maxResults);
        }
        return typedQuery;
    }

    @Override
    @Transactional(readOnly=true)
    public int count(F filter) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery countCriteriaQuery = cb.createQuery(Long.class);
        Root root = countCriteriaQuery.from(this.type);
        countCriteriaQuery.where((Expression)this.createWhereCondition(root, filter));
        countCriteriaQuery.select((Selection)cb.count((Expression)root));
        TypedQuery countTypedQuery = this.em.createQuery(countCriteriaQuery);
        return ((Long)countTypedQuery.getSingleResult()).intValue();
    }

    @Override
    @Transactional(readOnly=false)
    public <Q extends T> Q create(Q newInstance) {
        this.em.persist(newInstance);
        return newInstance;
    }

    protected abstract Predicate createWhereCondition(Root<T> var1, F var2);

    @Override
    @Transactional(readOnly=false)
    public void delete(PK primaryKey) {
        this.delete((Q)this.read(primaryKey));
    }

    @Override
    @Transactional(readOnly=false)
    public <Q extends T> void delete(Q transientObject) {
        this.em.remove(transientObject);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> find(F filter, OrderByList<? extends AbstractOrderBy<?>> orderByList, int firstResult, int maxResults) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(this.type);
        Root root = criteriaQuery.from(this.type);
        Predicate where = this.createWhereCondition(root, filter);
        where = this.extendWhereCondition(where, filter);
        criteriaQuery.where((Expression)where);
        this.addOrderBy(root, criteriaQuery, orderByList);
        TypedQuery typedQuery = this.em.createQuery(criteriaQuery);
        this.addPagination(typedQuery, firstResult, maxResults);
        return typedQuery.getResultList();
    }

    protected Predicate extendWhereCondition(Predicate where, F filter) {
        if (filter instanceof ExtendedFilter) {
            CriteriaBuilder cb = this.em.getCriteriaBuilder();
            Predicate extendedPredicate = ((ExtendedFilter)filter).getPredicate();
            if (extendedPredicate != null) {
                return cb.and((Expression)where, (Expression)extendedPredicate);
            }
        }
        return where;
    }

    @Override
    @Transactional(readOnly=true)
    public void initMetamodel() {
        this.em.flush();
        this.em.getMetamodel();
    }

    @Override
    @Transactional(readOnly=true)
    public T read(PK primaryKey) {
        return (T)this.em.find(this.type, primaryKey);
    }

    @Override
    @Transactional(readOnly=false)
    public <Q extends T> Q update(Q transientObject) {
        return (Q)this.em.merge(transientObject);
    }

    @Override
    @Transactional(readOnly=true)
    public T read(PK primaryKey, LockModeType lockMode) {
        return (T)this.em.find(this.type, primaryKey, lockMode);
    }
}

