/*
 * Decompiled with CFR 0.152.
 */
package com.everit.jpa.persistenceunit;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.spi.PersistenceUnitInfo;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;

public class SpringPersistenceUnitManager
extends DefaultPersistenceUnitManager
implements ApplicationContextAware {
    private static Logger log = Logger.getLogger(SpringPersistenceUnitManager.class.getName());
    private ApplicationContext ac = null;
    private List<String> jarLocationPatterns;

    public void setJarLocationPatterns(List<String> jarLocationPatterns) {
        this.jarLocationPatterns = jarLocationPatterns;
    }

    public List<String> getJarLocationPatterns() {
        return this.jarLocationPatterns;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ac = applicationContext;
    }

    public PersistenceUnitInfo obtainDefaultPersistenceUnitInfo() {
        PersistenceUnitInfo persistenceUnitInfo = super.obtainDefaultPersistenceUnitInfo();
        return this.removePersistenceUnitInfo(persistenceUnitInfo);
    }

    public PersistenceUnitInfo obtainPersistenceUnitInfo(String persistenceUnitName) {
        PersistenceUnitInfo persistenceUnitInfo = super.obtainPersistenceUnitInfo(persistenceUnitName);
        return this.removePersistenceUnitInfo(persistenceUnitInfo);
    }

    protected void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        super.postProcessPersistenceUnitInfo(pui);
        pui.addJarFileUrl(pui.getPersistenceUnitRootUrl());
        PersistenceUnitInfo oldPui = this.getPersistenceUnitInfo(pui.getPersistenceUnitName());
        List currentURLs = pui.getJarFileUrls();
        if (oldPui != null) {
            List urls = oldPui.getJarFileUrls();
            for (URL url : urls) {
                if (currentURLs.contains(url)) continue;
                pui.addJarFileUrl(url);
            }
        }
        currentURLs = pui.getJarFileUrls();
        for (String jarLocationPattern : this.jarLocationPatterns) {
            try {
                Resource[] resources;
                log.info("Processing jar location pattern for JPA: " + jarLocationPattern);
                for (Resource r : resources = this.ac.getResources(jarLocationPattern)) {
                    URL rURL = r.getURL();
                    log.info("Found jar file: " + rURL.toString());
                    if (currentURLs.contains(rURL)) continue;
                    pui.addJarFileUrl(rURL);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private PersistenceUnitInfo removePersistenceUnitInfo(PersistenceUnitInfo persistenceUnitInfo) {
        persistenceUnitInfo.getJarFileUrls().remove(persistenceUnitInfo.getPersistenceUnitRootUrl());
        return persistenceUnitInfo;
    }
}

